/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.common.blocks;

import com.minecraftabnormals.buzzier_bees.core.registry.BBItems;
import com.mojang.datafixers.util.Pair;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class HoneyPotBlock
extends Block
implements ISidedInventoryProvider {
    public static final IntegerProperty HONEY_LEVEL = IntegerProperty.func_177719_a((String)"honey_level", (int)0, (int)4);
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.func_200696_a((Object)new VoxelShape[5], levels -> {
        for (int i = 0; i < 5; ++i) {
            int level = i >= 1 ? i + 1 : i;
            levels[i] = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)Block.func_208617_a((double)3.0, (double)Math.max(2, level * 3), (double)3.0, (double)13.0, (double)16.0, (double)13.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        }
    });

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        Pair<ItemStack, Integer> output = HoneyPotBlock.getOutput(stack, (Integer)state.func_177229_b((Property)HONEY_LEVEL));
        ItemStack outputItem = (ItemStack)output.getFirst();
        if (outputItem != ItemStack.field_190927_a) {
            player.func_184609_a(handIn);
            if (outputItem.func_77973_b() == Items.field_226639_pY_) {
                HoneyPotBlock.attemptEmpty(state, worldIn, pos, output);
            } else if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(handIn, outputItem);
                } else if (!player.field_71071_by.func_70441_a(outputItem)) {
                    player.func_71019_a(outputItem, false);
                }
            }
            if (!worldIn.field_72995_K) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)output.getSecond()));
            }
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_226135_eP_, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    private static BlockState attemptEmpty(BlockState state, World world, BlockPos pos, Pair<ItemStack, Integer> output) {
        if (!world.field_72995_K) {
            double d0 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            double d1 = (double)(world.field_73012_v.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
            double d2 = (double)(world.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
            ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, (ItemStack)output.getFirst());
            itementity.func_174869_p();
            world.func_217376_c((Entity)itementity);
        }
        return state;
    }

    private static Pair<ItemStack, Integer> getOutput(ItemStack input, int level) {
        boolean notFull;
        Item item = input.func_77973_b();
        Pair<ItemStack, Integer> output = Pair.of((Object)ItemStack.field_190927_a, (Object)level);
        boolean notEmpty = level > 0;
        boolean bl = notFull = level < 4;
        if (item == Items.field_151069_bo && notEmpty) {
            output = HoneyPotBlock.createItemStack(Items.field_226638_pX_, level - 1);
        } else if (item == Items.field_151025_P && notEmpty) {
            output = HoneyPotBlock.createItemStack((Item)BBItems.HONEY_BREAD.get(), level - 1);
        } else if (item == Items.field_151034_e && notEmpty) {
            output = HoneyPotBlock.createItemStack((Item)BBItems.HONEY_APPLE.get(), level - 1);
        } else if (item == Items.field_151157_am && notEmpty) {
            output = HoneyPotBlock.createItemStack((Item)BBItems.GLAZED_PORKCHOP.get(), level - 1);
        } else if (item == BBItems.HONEY_WAND.get() && notEmpty) {
            output = HoneyPotBlock.createItemStack((Item)BBItems.STICKY_HONEY_WAND.get(), level - 1);
        } else if (item == Items.field_190931_a && level == 4) {
            output = HoneyPotBlock.createItemStack(Items.field_226639_pY_, level - 4);
        } else if (item == Items.field_226638_pX_ && notFull) {
            output = HoneyPotBlock.createItemStack(Items.field_151069_bo, level + 1);
        } else if (item == BBItems.STICKY_HONEY_WAND.get() && notFull) {
            output = HoneyPotBlock.createItemStack((Item)BBItems.HONEY_WAND.get(), level + 1);
        } else if (item == Items.field_226639_pY_ && level == 0) {
            output = HoneyPotBlock.createItemStack(Items.field_190931_a, level + 4);
        } else if (item == Items.field_226635_pU_ && notFull) {
            Random rand = new Random();
            int amount = rand.nextInt(3) == 0 ? 1 : 0;
            output = HoneyPotBlock.createItemStack(Items.field_190931_a, level + amount);
        }
        return output;
    }

    private static Pair<ItemStack, Integer> createItemStack(Item item, int level) {
        return Pair.of((Object)new ItemStack((IItemProvider)item), (Object)level);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HONEY_LEVEL});
    }

    public HoneyPotBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)HONEY_LEVEL)];
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)HONEY_LEVEL)];
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((Property)HONEY_LEVEL);
    }

    public ISidedInventory func_219966_a(BlockState state, IWorld world, BlockPos pos) {
        int i = (Integer)state.func_177229_b((Property)HONEY_LEVEL);
        if (i == 4) {
            return new FullInventory(state, world, pos, new ItemStack((IItemProvider)Items.field_226639_pY_));
        }
        return i < 7 ? new PartialInventory(state, world, pos) : new EmptyInventory();
    }

    static class PartialInventory
    extends Inventory
    implements ISidedInventory {
        private final BlockState state;
        private final IWorld world;
        private final BlockPos pos;
        private boolean inserted;

        public PartialInventory(BlockState state, IWorld world, BlockPos pos) {
            super(1);
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int func_70297_j_() {
            return 1;
        }

        public int[] func_180463_a(Direction side) {
            int[] nArray;
            if (side == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
            Item item = itemStackIn.func_77973_b();
            return !this.inserted && direction == Direction.UP && (item == Items.field_226635_pU_ || item == Items.field_226639_pY_);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public void func_70296_d() {
            ItemStack itemstack = this.func_70301_a(0);
            if (!itemstack.func_190926_b()) {
                this.inserted = true;
                this.attemptInteract(this.state, this.pos, (World)this.world, itemstack);
                this.func_70304_b(0);
            }
        }

        private boolean attemptInteract(BlockState state, BlockPos pos, World world, ItemStack stack) {
            int level = (Integer)state.func_177229_b((Property)HONEY_LEVEL);
            if (stack.func_77973_b() == Items.field_226635_pU_ && level < 4) {
                if (world.field_73012_v.nextInt(3) == 0) {
                    world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(level + 1)));
                    return true;
                }
            } else if (stack.func_77973_b() == Items.field_226639_pY_ && level == 0) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(level + 4)));
                return true;
            }
            return false;
        }
    }

    static class FullInventory
    extends Inventory
    implements ISidedInventory {
        private final BlockState state;
        private final IWorld world;
        private final BlockPos pos;
        private boolean extracted;

        public FullInventory(BlockState state, IWorld world, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.world = world;
            this.pos = pos;
        }

        public int func_70297_j_() {
            return 1;
        }

        public int[] func_180463_a(Direction side) {
            int[] nArray;
            if (side == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
            return false;
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return !this.extracted && direction == Direction.DOWN && stack.func_77973_b() == Items.field_226639_pY_;
        }

        public void func_70296_d() {
            this.world.func_180501_a(this.pos, (BlockState)this.state.func_206870_a((Property)HONEY_LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.extracted = true;
        }
    }

    static class EmptyInventory
    extends Inventory
    implements ISidedInventory {
        public EmptyInventory() {
            super(0);
        }

        public int[] func_180463_a(Direction side) {
            return new int[0];
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
            return false;
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return false;
        }
    }
}

